// VRPNDLLClientDevice.cpp : interface with the game engine

#include "stdafx.h"
#include <stdio.h>

#include "VRPNDLLClient.h"
#include "VRPNDLLClientStructs.h"

extern "C"
{
	// Start threads
	__declspec(dllexport) void VRPNDLLClient_StartDevice()
	{
		VRPNDLLClient::GetInstance()->Start();
	}

	// Stop threads and clean data
	__declspec(dllexport) void VRPNDLLClient_StopDevice()
	{
		VRPNDLLClient::GetInstance()->Stop();
	}

	// Setup the weapon
	__declspec(dllexport) void VRPNDLLClient_SetupDevice(const char * deviceName, int buttonsChannel, int yawChannel, int pitchChannel, int rollChannel, int deltaXChannel, int deltaYChannel, int deltaZChannel)
	{
		VRPNDLLClient::GetInstance()->SetupDevice(deviceName, buttonsChannel, yawChannel, pitchChannel, rollChannel, deltaXChannel, deltaYChannel, deltaZChannel);
	}

	// Get the channnels values in a composite function 
	__declspec(dllexport) void VRPNDLLClient_ReadDevice(DeviceValues * dValues)
	{
		dValues->buttons = VRPNDLLClient::GetInstance()->Buttons();

		dValues->yaw = VRPNDLLClient::GetInstance()->Yaw();
		dValues->pitch = VRPNDLLClient::GetInstance()->Pitch();
		dValues->roll = VRPNDLLClient::GetInstance()->Roll();

		dValues->deltaX = VRPNDLLClient::GetInstance()->DeltaX();
		dValues->deltaY = VRPNDLLClient::GetInstance()->DeltaY();
		dValues->deltaZ = VRPNDLLClient::GetInstance()->DeltaZ();

	}
}
